DefConst('kMyNewtInfoButton,
	{
		_proto: newtInfoButton,
		DoInfoAux:func(auxArray,index) begin			
			if index = 0 then BuildContext(GetLayout("Utilities.t")):Open();
			else if index = 1 then begin
				if GetRoot().(kHyperLinkManagerAppSymbol) then
					GetRoot().(kHyperLinkManagerAppSymbol):Open();
				else GetRoot():Notify(kNotifyAlert, kAppTitle, LocObj("", '[pathExpr: HyperLinkManager, HLMNotInstalled]));
			end;
			else if index = 2 then begin
				:ShowToolbar(not :PrefsLookup('showToolbar));
			end;
		end,
		GenInfoAuxItems: func() begin
			local arr := [ LocObj("", '[pathExpr: Utilities, title]), LocObj("", '[pathExpr: HyperLinkManager, title]) ];

			if :PrefsLookup('showToolbar) then
				AddArraySlot(arr,  LocObj("", '[pathExpr: preferences, hideToolbar]));
			else AddArraySlot(arr,  LocObj("", '[pathExpr: preferences, showToolbar]));
				
			arr;
		end,
		viewSetupDoneScript: func() begin
			inherited:?viewSetupDoneScript();
			newtAppBase._infoKeyButton := self;
		end,
		viewQuitScript: func() begin
			inherited:?viewQuitScript();
			RemoveSlot(newtAppBase, '_infoKeyButton);
		end,
	}
);


/* kMyNewtNewStationeryButton
 * --------------------------
 * Get the new picker to recognize stationery registered
 * with notes, as well as to add the new directory item.
 *
 */

DefConst('kMyNewtNewStationeryButton,
	{
		_proto: newtNewStationeryButton,

		BuildPopup: func() begin
			local popupAdditionArray, statAdditionArray;
			
			inherited:?BuildPopup();

			statAdditionArray := [ 'directory,  nil, ];
			popupAdditionArray := [ { item: LocObj("", '[pathExpr: buttons, newDirectoryItem]), icon: kDirectoryIcon, indent: 24, },
			 					'pickSeparator, ];

			ArrayMunger(popupAdditionArray, Length(popupAdditionArray), nil, popup, 0, nil);
			ArrayMunger(statAdditionArray, Length(statAdditionArray), nil, statArray, 0, nil);
			
			popup := popupAdditionArray;
			statArray := statAdditionArray;			
		end,

		StatScript: func(stationeryItem) begin
			if stationeryItem = 'Directory then :NewDirectory(nil, newtAppBase);
			else begin
				if :PrefsLookup('displayWithNotepad) and not :PrefsLookup('replaceNotepad) then begin
					local notepad := GetRoot().paperroll;
					local entry, directoryID;
					
					if not Visible(notepad) then
						notepad:Open();
					notepad:MoveBehind(nil);
					
					entry := notepad:AddEntryFromStationery(stationeryItem.symbol);
					directoryID := :DirectoryInfo('directoryID);
					
					if not directoryID then
						directoryID := kRootID;
					entry.(kAppSymbol).parentID := directoryID;
					EntryChangeXmit(entry, kAppSymbol);
				end;
				else begin
					inherited:?StatScript(stationeryItem);
	
					if :PrefsLookup('autoPopupTitle) then AddDeferredCall(func(context) begin
						local entryView := context:GetTargetView();
					
						if entryView.theHeaderView.popIt then
							entryView.theHeaderView:Popit(true);
					end, [self] );
				end;
			end;
		end,
	}
);